<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Custom FAQ Accordion</title>
  <style>
    .faq-container-unique {
      font-family: Arial, sans-serif;
      max-width: 800px;
      margin: 0 auto;
    }

    .faq-title-unique {
      text-align: center;
      font-size: 2rem;
      font-weight: bold;
      margin-bottom: 20px;
    }

    .faq-item-unique {
      border: 1px solid #ccc;
      margin-bottom: 10px;
      border-radius: 4px;
      overflow: hidden;
    }

    .faq-question-unique {
      background-color: #00b4c5;
      color: white;
      padding: 15px 20px;
      cursor: pointer;
      position: relative;
      font-weight: bold;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .faq-question-unique::before {
      content: '+';
      font-size: 1.2rem;
      margin-right: 10px;
    }

    .faq-item-unique.open .faq-question-unique::before {
      content: '−';
    }

    .faq-answer-unique {
      background-color: #fff;
      color: #333;
      padding: 20px;
      display: none;
    }

    .faq-item-unique.open .faq-answer-unique {
      display: block;
    }
  </style>
</head>
<body>
  <div class="faq-container-unique">
    <div class="faq-title-unique">FAQ</div>

    <div class="faq-item-unique open">
      <div class="faq-question-unique">Low water flow from RO machine?</div>
      <div class="faq-answer-unique">
      Solution: Inspect the pre-filter and membrane for any obstructions or blockages. In case the pre-filter is soiled, take action to clean or replace it. If the membrane is congested or impaired, it will require replacement. It is also advisable to examine the water pressure and ensure it falls within the recommended limits.
      </div>
    </div>

    <div class="faq-item-unique">
      <div class="faq-question-unique">Is the RO machine not producing clean water?</div>
      <div class="faq-answer-unique">
      Solution: Inspect the pre-filter and membrane for any obstructions or impairments. If there is dirt or damage, proceed to clean or replace them accordingly. Additionally, ensure that the water pressure is within the advised range. If the issue persists, it may be related to the post-filter or storage tank, which would necessitate the assistance of a professional for repair.
      </div>
    </div>
  </div>

  <script>
     document.querySelectorAll('.faq-question-unique').forEach(button => {
      button.addEventListener('click', () => {
        const faqItem = button.parentElement;
        faqItem.classList.toggle('open');
      });
    });
  </script>
</body>
</html>
